<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Post;

use Erlage\Photogram\System;
use Erlage\Photogram\Data\Tables\Post\PostTable;
use Erlage\Photogram\Data\Models\InterfaceModelBuilder;
use Erlage\Photogram\Data\Dtos\Post\PostMetaHashtagsDTO;
use Erlage\Photogram\Data\Dtos\Post\PostDisplayContentDTO;

final class PostBuilder implements InterfacePostSetter, InterfaceModelBuilder
{
    /**
     * setter interface
     */

    use TraitPostSetters;

    /*
    |--------------------------------------------------------------------------
    | default values
    |--------------------------------------------------------------------------
    */

    /**
     * @var array
     */
    public $defaultValues;

    public function __construct()
    {
        $this -> defaultValues = self::defaultValues();
    }

    public static function defaultValues(): array
    {
        return array(
            PostTable::OWNER_USER_ID        => '',

            PostTable::DISPLAY_CAPTION      => '',
            PostTable::DISPLAY_LOCATION     => '',
            PostTable::DISPLAY_CONTENT      => new PostDisplayContentDTO(),

            PostTable::META_HASHTAGS        => new PostMetaHashtagsDTO(),

            PostTable::CACHE_LIKES_COUNT    => '0',
            PostTable::CACHE_COMMENTS_COUNT => '0',

            PostTable::STAMP_REGISTRATION   => System::isoDateTime(),
            PostTable::STAMP_LAST_UPDATE    => System::isoDateTime(),
        );
    }

    public function dispense(): PostModel
    {
        return PostModel::createFromData(
            array(
                // owner user id

                PostTable::OWNER_USER_ID => $this -> ownerUserId

                ?? $this -> defaultValues[PostTable::OWNER_USER_ID],

                // display caption

                PostTable::DISPLAY_CAPTION => $this -> displayCaption

                ?? $this -> defaultValues[PostTable::DISPLAY_CAPTION],

                // display location

                PostTable::DISPLAY_LOCATION => $this -> displayLocation

                ?? $this -> defaultValues[PostTable::DISPLAY_LOCATION],

                // display content

                PostTable::DISPLAY_CONTENT => $this -> displayContent

                ?? $this -> defaultValues[PostTable::DISPLAY_CONTENT],

                // meta hashtags

                PostTable::META_HASHTAGS => $this -> metaHashtags

                ?? $this -> defaultValues[PostTable::META_HASHTAGS],

                // cache likes count

                PostTable::CACHE_LIKES_COUNT => $this -> cacheLikesCount

                ?? $this -> defaultValues[PostTable::CACHE_LIKES_COUNT],

                // cache comments count

                PostTable::CACHE_COMMENTS_COUNT => $this -> cacheCommentsCount

                ?? $this -> defaultValues[PostTable::CACHE_COMMENTS_COUNT],

                // stamp registration

                PostTable::STAMP_REGISTRATION => $this -> stampRegistration

                ?? $this -> defaultValues[PostTable::STAMP_REGISTRATION],

                // stamp last update

                PostTable::STAMP_LAST_UPDATE => $this -> stampLastUpdate

                ?? $this -> defaultValues[PostTable::STAMP_LAST_UPDATE],
            )
        );
    }
}
